
/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QWidget>
#include <QDoubleSpinBox>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include "MsXpS/libXpertMassCore/Tolerance.hpp"


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"


namespace Ui
{
class ToleranceWidget;
}

namespace MsXpS
{
namespace libXpertMassGui
{


class DECLSPEC ToleranceWidget : public QWidget
{
  Q_OBJECT

  public:
  ToleranceWidget(QWidget *parent,
                  const QString &config_settings_file_path,
                  double nominal,
                  libXpertMassCore::Tolerance::Type type);
  ToleranceWidget(QWidget *parent, const QString &config_settings_file_path);

  ~ToleranceWidget();

  void writeSettings(const QString &config_settings_file_path);
  void readSettings(const QString &config_settings_file_path);

  Q_INVOKABLE void setNominal(double nominal);
  Q_INVOKABLE double getNominal() const;
  Q_INVOKABLE void setType(libXpertMassCore::Tolerance::Type type);
  Q_INVOKABLE libXpertMassCore::Tolerance::Type getType() const;

  public slots:
  void nominalDoubleSpinBoxValueChanged(double value);
  void typeComboBoxValueChanged(const QString &text);

  signals:
  void nominalChangedSignal();
  void typeChangedSignal();
  void toleranceChangedSignal(std::pair<double, libXpertMassCore::Tolerance::Type>);

  private:
  QString m_configSettingsFilePath;

  bool m_isInitialized = false;

  libXpertMassCore::Tolerance *mp_tolerance = new libXpertMassCore::Tolerance(this);

  Ui::ToleranceWidget *mp_ui;

  void initializeTolerance(double nominal, libXpertMassCore::Tolerance::Type type);
  void initializeTolerance(const libXpertMassCore::Tolerance &tolerance);
  bool initializeToleranceFromSettings();
  void setupWidgetCommon();
  void setupWidget();
  void setupWidget(double nominal, libXpertMassCore::Tolerance::Type type);
};

} // namespace libXpertMassGui

} // namespace MsXpS
