# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::RU;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250913135859;

my $formatters = [
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '[0-79]',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                [0-356]2|
                4[29]|
                7|
                8[27]
              )|
              2(?:
                13[03-69]|
                62[013-9]
              )
            )|
            72[1-57-9]2
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                0(?:
                  [356]|
                  4[023]
                )|
                [18]|
                2(?:
                  3[013-9]|
                  5
                )|
                3[45]|
                43[013-79]|
                5(?:
                  3[1-8]|
                  4[1-7]|
                  5
                )|
                6(?:
                  3[0-35-9]|
                  [4-6]
                )
              )|
              2(?:
                1(?:
                  3[178]|
                  [45]
                )|
                [24-689]|
                3[35]|
                7[457]
              )
            )|
            7(?:
              14|
              23
            )4[0-8]|
            71(?:
              33|
              45
            )[1-79]
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{5})(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3-$4',
                  'leading_digits' => '
            [349]|
            8(?:
              [02-7]|
              1[1-8]
            )
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '8',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          336(?:
            [013-9]\\d|
            2[013-9]
          )\\d{5}|
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15-7]|
              6[0-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'geographic' => '
          336(?:
            [013-9]\\d|
            2[013-9]
          )\\d{5}|
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15-7]|
              6[0-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'mobile' => '9\\d{9}',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(80[39]\\d{7})',
                'toll_free' => '
          8(?:
            0[04]|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"7845", "Saratov",
"771034", "Zhezdy",
"772146", "Karkaralinsk",
"772932", "Beineu",
"772338", "Bozanbai\/Molodezhnyi",
"771145", "Karatobe\ District",
"7301", "Republic\ of\ Buryatia",
"7848", "Tolyatti",
"7831", "Nizhni\ Novgorod",
"7855", "Naberezhnye\ Chelny",
"77135", "Aktobe\ Region",
"772348", "Kokpekty",
"7486", "Orel",
"771135", "Zhanibek",
"771349", "Shalkarsky\ District",
"772771", "Kaskelen",
"771642", "Egendykol",
"771651", "Kabanbai\ Batyr",
"772640", "Moiynkumsky\ District",
"77224", "Barshatas",
"771632", "Zerenda",
"771339", "Komsomolskoye",
"771036", "Balkhash",
"77112", "Uralsk",
"7391", "Krasnoyarsk\ Territory",
"772144", "Kiyevka",
"771430", "Arkalyk",
"7302", "Chita",
"771546", "Talshik",
"771836", "Sharbakty",
"772236", "Beskaragai",
"772432", "Shiyeli",
"771457", "Dzhangildinsky\ District",
"771235", "Dossor",
"772835", "Tekeli",
"772545", "Ikan",
"771440", "Amangeldy",
"772159", "Karaganda\ Region",
"771536", "Taiynsha",
"772535", "Shardara",
"772773", "Bakanas",
"736", "Simferopol",
"7346", "Surgut",
"77122", "Atyrau",
"77282", "Taldykorgan",
"7863", "Rostov",
"771534", "Sergeyevka",
"771844", "Irtyshsky\ District",
"77213", "Aktau\/Temirtau",
"7411", "Republic\ of\ Sakha",
"77252", "Shymkent",
"771834", "Uspenka",
"771544", "Presnovka",
"771137", "Chingirlau",
"7821", "Komi\ Republic",
"7879", "Mineranye\ Vody",
"771147", "Akzhaiksky\ District",
"7473", "Voronezh",
"772774", "Talgar",
"7382", "Tomsk",
"772131", "Abai",
"772439", "Aralsky\ District",
"771041", "Aktau\,\ Zhezkazgan",
"771438", "Amangeldy",
"771843", "Maisky\ District",
"771533", "Saumalkol",
"7353", "Orenburg",
"772776", "Shelek",
"771448", "Oktyabrskoye",
"771031", "Aksu\-Ayuly",
"7343", "Ekaterinburg",
"771543", "Yavlenka",
"771833", "Terenkol",
"7866", "Kabardino\-Balkarian\ Republic",
"77245", "Kyzylorda\ Region",
"772537", "Saryagash",
"7815", "Murmansk",
"77149", "Kostanai",
"771033", "Agadyr",
"7381", "Omsk",
"771831", "Zhelezinka",
"771541", "Mamlutka",
"7483", "Bryansk",
"771455", "Zatobolsk",
"772547", "Lenger",
"772837", "Kabanbai",
"771237", "Kulsary",
"772252", "Karaul",
"7818", "Arkhangelsk",
"771043", "Zhairem",
"771531", "Bulayevo",
"771841", "Aktogai",
"772638", "Tole\ bi",
"771332", "Uil",
"771639", "Stepnyak",
"772330", "Zyryanovsky\ District",
"7712302", "Tengizshevroil",
"7496", "Moscow",
"771649", "Zhaksynsky\ District",
"7877", "Republic\ of\ Adygeya",
"771342", "Badamsha",
"772340", "Zaisan",
"733622", "Baikonur",
"7861", "Krasnodar\ Territory",
"7492", "Vladimir",
"772937", "Kuryk",
"772839", "Sarkand",
"771239", "Makat",
"772539", "Kazygurt",
"7413", "Magadan",
"771433", "Lisakovsk",
"771538", "Beskol",
"772631", "Kulan",
"771647", "Esil",
"77125", "Atyrau\ Region",
"771443", "Borovskoi",
"772641", "Akkol",
"771838", "Koktobe",
"771637", "Korgalzhyn",
"772770", "Uzynagash",
"77272956", "Talgar",
"771452", "Karasu",
"7814", "Republic\ of\ Karelia",
"772334", "Tavricheskoye",
"772437", "Zhosaly",
"771441", "Karabalyk",
"771038", "Shashubai",
"771149", "Zelenovsky\ District",
"772643", "Shu",
"772344", "Akzhar",
"7862", "Sochi",
"77132", "Aktobe\/Kargalinskoye",
"7491", "Ryazan",
"771139", "Taskala",
"771431", "Rudny",
"7878", "Karachayevo\-Cherkessian\ Republic",
"772633", "Asa",
"771345", "Karauylkeldy",
"772138", "Gabidena\ Mustafina",
"772346", "Aksuat",
"771335", "Shalkar",
"772148", "Molodezhnoye",
"7833", "Kirov",
"7817", "Vologda",
"772336", "Ridder",
"77162", "Kokshetau\/Krasni\ Yar",
"772644", "Karatau",
"7844", "Volgograd",
"772333", "Samarskoye",
"7427", "Chukotka\ Autonomous\ District",
"771132", "Fyodorovka",
"7342", "Perm",
"771459", "Kostanai\ Region",
"772634", "Zhanatas",
"772343", "Terekty",
"7352", "Kurgan",
"772935", "Zhetybai",
"771142", "Taipak",
"7481", "Smolensk",
"7383", "Novosibirsk",
"771635", "Zhaksy",
"7472", "Belgorod",
"7857", "Luhansk\ People\'s\ Republic",
"771030", "Atasu",
"7836", "Republic\ of\ Marij\ El",
"772636", "Kordai",
"771645", "Stepnogorsk",
"7424", "Sakhalin\ Region",
"771040", "Zhairem\ \(GOK\)",
"77292", "Aktau",
"7847", "Republic\ of\ Kalmykia",
"771446", "Uzunkolsky\ District",
"771840", "Bayanaul",
"77272", "Almaty",
"7416", "Amur\ Region",
"7351", "Chelyabinsk",
"772532", "Abai",
"772842", "Kogaly",
"771436", "Taranovskoye",
"771540", "Kishkenekol",
"772230", "Urdzhar",
"772257", "Shulbinsk",
"772435", "Zhanakorgan",
"772542", "Asykata",
"772832", "Zhansugurov",
"7341", "Udmurtian\ Republic",
"771232", "Atyrau\ Region",
"772778", "Chundzha",
"772341", "Ulken\ Naryn",
"771434", "Denisovka",
"771337", "Alga",
"7482", "Tver",
"772331", "Glubokoye",
"771444", "Uzunkol",
"7471", "Kursk",
"771347", "Aitekebisky\ District",
"77242", "Kyzylorda",
"771537", "Timiryazevo",
"771648", "Derzhavinsk",
"771231", "Akkystau",
"772541", "Myrzakent",
"772831", "Zharkent",
"771547", "Zhambylsky\ District",
"771837", "Aksu",
"772237", "Ayagoz",
"7499", "Moscow",
"7812", "St\ Petersburg",
"771456", "Kachar",
"772531", "Aksukent",
"772841", "Kapal",
"771638", "Akkol",
"772332", "Shemonaikha",
"771454", "Karamendy",
"772938", "Fort\ Shevchenko",
"772639", "Saudakent",
"771133", "Aksai",
"771330", "Khromtau\ District",
"77279", "Almaty",
"772342", "Katon\-Karagai",
"771143", "Akzhaik",
"772351", "Borodulikha",
"771340", "Khobdinsky\ District",
"7867", "Republic\ of\ North\ Ossetia",
"772353", "Novaya\ Shulba",
"772137", "Saran",
"7811", "Pskov",
"7869", "Sevastopol",
"7385", "Altai\ Territory",
"771449", "Taranovskoye",
"771141", "Zhangala",
"7494", "Kostroma",
"772147", "Egindybulak",
"7388", "Republic\ of\ Altai",
"771131", "Darinskoye",
"771439", "Torgai",
"772438", "Aiteke\ bi",
"772843", "Lepsy",
"772533", "Turkestan",
"772775", "Esik",
"7820", "Cherepovets",
"771037", "Aktogai",
"771233", "Ganyushkino",
"772543", "Aqsumbe",
"772833", "Usharal",
"7841", "Penza",
"772546", "Sholakkorgan",
"772836", "Karabulak",
"771236", "Makhambet",
"771545", "Zhambylsky\ District",
"771451", "Sarykol",
"772536", "Kentau",
"7835", "Chuvashi\ Republic",
"7851", "Astrakhan",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"771442", "Fyodorovka",
"771845", "Pavlodar\ Area",
"771535", "Novoishimski",
"7487", "Tula",
"7873", "Ingushi\ Republic",
"7484", "Kaluga",
"77222", "Semey",
"77182", "Pavlodar",
"772534", "Zhetysai",
"7712303", "Tengizs",
"7421", "Khabarovsk\ Territory",
"772757", "Akshi",
"77152", "Petropavlovsk",
"7395", "Irkutsk",
"771234", "Indernborski",
"772544", "Shaulder",
"772834", "Ushtobe",
"771146", "Akzhaiksky\ District",
"7390", "Republic\ of\ Khakassia",
"7842", "Ulyanovsk",
"77102", "Zhezkazgan",
"771136", "Chapayev",
"771348", "Shalkarsky\ District",
"7347", "Republic\ of\ Bashkortostan",
"772642", "Moiynkum",
"771453", "Auliekol",
"771134", "Zhympity",
"771640", "Balkashino",
"771035", "Ulytau",
"7415", "Kamchatka\ Region",
"772632", "Merke",
"772339", "Kurchum",
"77212", "Karaganda",
"772777", "Kegen",
"7474", "Lipetsk",
"771144", "Kaztalovka",
"771630", "Burabay",
"772840", "Saryozek",
"772530", "Temirlanovka",
"772251", "Kurchatov",
"771445", "Ubaganskoye",
"7426", "Jewish\ Autonomous\ Region",
"771842", "Koktobe",
"771532", "Smirnovo",
"7834", "Republic\ of\ Mordovia",
"772436", "Terenozek",
"772830", "Alakolsky\ District",
"772540", "Arys",
"771230", "Atyrau\ Region",
"771435", "Zhitikara",
"771542", "Kishkenekol",
"771832", "Irtyshsk",
"7485", "Yaroslavl",
"771341", "Khobda",
"772779", "Narynkol",
"7813", "Leningrad\ region",
"7856", "Donetsk\ People\'s\ Republic",
"772337", "Serebryansk",
"772153", "Topar",
"771331", "Martuk",
"7846", "Samara",
"7394", "Republic\ of\ Tuva",
"772347", "Kalbatau",
"77142", "Kostanai",
"77262", "Taraz",
"771644", "Arshaly",
"771130", "Peremetnoye",
"771333", "Kandyagash",
"77273", "Almaty",
"772132", "Nurinsky\ District",
"771140", "Saikhin",
"77145834", "Krasnogorsk",
"771343", "Irgiz",
"7345", "Tyumen",
"77274", "Karassaisky\ District",
"771032", "Karazhal",
"772635", "Bauyrzhan\ Mamyshuly",
"771458", "Kostanai\ Region",
"772934", "Zhanaozen",
"772725", "Otegen\ Batyra",
"772759", "Almaty\ Region",
"771636", "Shuchinsk",
"771042", "Zharyk",
"740", "Kaliningrad",
"7475", "Tambov",
"771646", "Makinsk",
"7865", "Stavropol\ territory",
"771334", "Emba",
"771437", "Kamysty",
"772149", "Osakarovka",
"772256", "Kainar",
"771643", "Atbasar",
"771447", "Karabalyksky\ District",
"77232", "Ust\-Kamenogorsk",
"772431", "Zhalagash",
"7872", "Republic\ of\ Daghestan",
"771633", "Ereimentau",
"772345", "Shar",
"77187", "Ekibastuz",
"771138", "Zhalpaktal",
"77272983", "Kaskelen",
"771346", "Shubarkuduk",
"772335", "Zyryanovsk",
"771039", "Priozersk",
"771336", "Khromtau",
"772752", "Otegen\ Batyra",
"7498", "Moscow",
"771839", "Akku",
"772239", "Makanchi",
"7717", "Astana",
"7871", "Chechen\ Republic",
"7384", "Kemerovo",
"7495", "Moscow",
"771539", "Beskol",
"772931", "Shetpe",
"7423", "Primorie\ territory",
"77106", "Satpaev",
"772156", "Shakhtinsk",
"772433", "Aralsk",
"772538", "Turara\ Ryskulova",
"772154", "Botakara",
"771631", "Shortandy",
"77185", "Shaldai",
"7843", "Republic\ of\ Tatarstan",
"7860", "Kherson\ Region",
"771641", "Astrakhanka",
"772772", "Kapchagai",
"771238", "Miyaly",
"772548", "Shayan",
"772838", "Balpyk\ bi",
"772637", "Sarykemer",
"7816", "Veliky\ Novgorod",};
$areanames{ru} = {"771038", "Сыры\-Шаган",
"771441", "Карабалыкский\ р\-н",
"771149", "Акжаикский\ р\-н",
"772643", "Шуский\ р\-н",
"772334", "Уланский\ р\-н",
"7814", "Республика\ Карелия",
"771452", "Карасуский\ р\-н",
"772437", "Кармакшинский\ р\-н",
"771139", "Таскалинский\ р\-н",
"771431", "Рудный",
"7878", "Республика\ Карачаево\-Черкесская",
"772633", "Жамбылский\ р\-н",
"7862", "Краснодарский\ край",
"772344", "Тарбагатайский\ р\-н",
"77132", "Актобе\/Актюбинск",
"7491", "Рязанская\ обл\.",
"772346", "Тарбагатайский\ р\-н",
"771345", "Байганинский\ р\-н",
"772138", "Бухар\-Жырауский\ р\-н",
"7833", "Кировская\ обл\.",
"772336", "Риддер",
"7817", "Вологодская\ обл\.",
"771335", "Шалкарский\ р\-н",
"772148", "Осакаровский\ р\-н",
"771239", "Макатский\ р\-н",
"772839", "Саркандский\ р\-н",
"733622", "Байконыр",
"7861", "Краснодарский\ край",
"772937", "Каракиянский\ р\-н",
"7492", "Владимирская\ обл\.",
"772539", "Казыгурт",
"7413", "Магаданская\ обл\.",
"771647", "Есильский\ р\-н",
"77125", "Атырауская\ область",
"771433", "Лисаковск",
"771538", "Кызылжарский\ р\-н",
"772631", "Турара\ Рыскулова\ р\-н",
"771637", "Коргалжынский\ р\-н",
"77272956", "Талгар",
"772770", "Жамбылский\ р\-н",
"771443", "Мендыкаринский\ р\-н",
"772641", "Таласский\ р\-н",
"771838", "Майский\ р\-он",
"7416", "Амурская\ обл\.",
"7351", "Челябинская\ обл\.",
"772532", "Абая",
"772842", "Кербулакский\ р\-н",
"771446", "Узункольский\ р\-н",
"771840", "Баянаульский\ р\-н",
"77272", "Алма\-Ата",
"772257", "Шульбинск",
"772435", "Жанакорганский\ р\-н",
"7341", "Республика\ Удмуртская",
"771232", "Атырауская\ область",
"772542", "Асыката",
"772832", "Аксуский\ р\-н",
"772778", "Уйгурский\ р\-н",
"771436", "Тарановский\ р\-н",
"772230", "Урджарский\ р\-н",
"771540", "Уалихановский\ р\-н",
"771434", "Денисовский\ р\-н",
"771337", "Алгинский\ р\-н",
"772341", "Катон\-Карагайский\ р\-н",
"771444", "Узункольский\ р\-н",
"7471", "Курская\ обл\.",
"771347", "Айтекебийский\ р\-н",
"77242", "Кызылорда",
"772331", "Глубоковский\ р\-н",
"7482", "Тверская\ обл\.",
"772333", "Кокпектинский\ р\-н",
"7427", "Чукотский\ АО",
"771132", "Теректинский\ р\-н",
"7342", "Пермский\ край",
"77162", "Кокшетау",
"772644", "Таласский\ р\-н",
"7844", "Волгоградская\ обл\.",
"772935", "Каракиянский\ р\-н",
"772343", "Курчумский\ р\-н",
"7352", "Курганская\ обл\.",
"771142", "Акжаикский\ р\-н",
"771459", "Костанайская\ область",
"772634", "Жанатас",
"771030", "Жана\-Аркинский\ р\-н",
"7857", "Луга́нская\ Наро́дная\ Респу́блика",
"7472", "Белгородская\ обл\.",
"7836", "Республика\ Марий\ Эл",
"772636", "Кордай",
"7481", "Смоленская\ обл\.",
"7383", "Новосибирская\ обл\.",
"771635", "Жаксынский\ р\-н",
"771040", "Жайрем\ \(ГОК\)",
"77292", "Актау",
"7847", "Республика\ Калмыкия",
"7424", "Сахалинская\ обл\.",
"771645", "Степногорск",
"772432", "Шиелийский\ р\-н",
"771457", "Джангильдинский\ р\-н",
"772835", "Текели",
"772545", "Икан",
"771235", "Макатский\ р\-н",
"7302", "Забайкальский\ край",
"771430", "Аркалык",
"772236", "Бескарагайский\ р\-н",
"771546", "Акжарский\ р\-н",
"771836", "Щербактинский\ р\-н",
"772535", "Шардара",
"772773", "Балхашский\ р\-н",
"736", "Республика\ Крым",
"771440", "Амангельдинский\ р\-н",
"772159", "Карагандинская\ область",
"771536", "Тайыншинский\ р\-н",
"77282", "Талдыкорган",
"77122", "Атырау",
"7863", "Ростовская\ обл\.",
"771844", "Иртышский\ р\-н",
"771534", "Шал\ Акына\ р\-н",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"77252", "Шымкент",
"771544", "Жамбылский\ р\-н",
"771834", "Успенский\ р\-н",
"7411", "Республика\ Саха\ \/Якутия\/",
"77213", "Темиртау",
"772338", "Уланский\ р\-н",
"772932", "Бейнеуский\ р\-н",
"771145", "Каратобинский\ р\-н",
"771034", "Улытауский\ р\-н",
"7845", "Саратовская\ обл\.",
"772146", "Каркаралинск",
"772348", "Кокпектинский\ р\-н",
"7486", "Орловская\ обл\.",
"771135", "Жанибекский\ р\-н",
"7301", "Республика\ Бурятия",
"7848", "Самарская\ обл\.",
"77135", "Актюбинская\ область",
"7831", "Нижегородская\ обл\.",
"7855", "Республика\ Татарстан",
"772640", "Мойынкумский\ р\-н",
"771651", "Целиноградский\ р\-н",
"771349", "Шалкарский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"772771", "Карасайский\ р\-н",
"771036", "Балхаш",
"77112", "Уральск",
"7493", "Ивановская\ обл\.",
"7391", "Красноярский\ край",
"772144", "Нуринский\ р\-н",
"77224", "Эмельтау",
"771632", "Зерендинский\ р\-н",
"771339", "Айтекебийский\ р\-н",
"771033", "Шетский\ р\-н",
"77149", "Костанай",
"7381", "Омская\ обл\.",
"7483", "Брянская\ обл\.",
"771831", "Железинский\ р\-н",
"771541", "Мамлютский\ р\-н",
"772537", "Сарыагаш",
"7815", "Мурманская\ обл\.",
"771043", "Жайрем\ \(поселок\)",
"771841", "Актогайский\ р\-н",
"771531", "Магжана\ Жумабаева\ р\-н",
"772638", "Шуский\ р\-н",
"771455", "Костанайский\ р\-н",
"771237", "Жылыойский\ р\-н",
"772837", "Алакольский\ р\-н",
"772547", "Ленгер",
"7818", "Архангельская\ обл\.",
"772252", "Абайский\ р\-н",
"772330", "Зыряновский\ р\-н",
"7496", "г\.\ Москва",
"7712302", "Тенгизшевройл",
"771332", "Уилский\ р\-н",
"771639", "Енбекшилдерский\ р\-н",
"772340", "Зайсанский\ р\-н",
"771649", "Жаксынский\ р\-н",
"771342", "Каргалинский\ р\-н",
"7877", "Республика\ Адыгея",
"7879", "Ставропольский\ край",
"771137", "Чингирлауский\ р\-н",
"7821", "Республика\ Коми",
"7382", "Томская\ обл\.",
"772131", "Абайский\ р\-н",
"772439", "Аральский\ р\-н",
"771147", "Акжаикский\ р\-н",
"7473", "Воронежская\ обл\.",
"772774", "Талгарский\ р\-н",
"772776", "Енбекшиказахский\ р\-н",
"771041", "Актау\,\ Жезказган",
"771438", "Амангельдинский\ р\-н",
"7353", "Оренбургская\ обл\.",
"771533", "Айыртауский\ р\-н",
"771843", "Майский\ р\-н",
"7866", "Республика\ Кабардино\-Балкарская",
"77245", "Кызылординская\ область",
"771448", "Карасуский\ р\-н",
"771031", "Шетский\ р\-н",
"7343", "Свердловская\ обл",
"771833", "Качирский\ р\-н",
"771543", "Есильский\ р\-н",
"771333", "Мугалжарский\ р\-н",
"77273", "Алма\-Ата",
"772132", "Нуринский\ р\-н",
"77262", "Тараз",
"771644", "Аршалынский\ р\-н",
"771130", "Зеленовский\ р\-н",
"771343", "Иргизский\ р\-н",
"77145834", "Красногорск",
"7345", "Тюменская\ обл\.",
"77274", "Карасайский\ р\-н",
"771140", "Бокейординский\ р\-н",
"772934", "Жанаозен",
"772725", "Отеген\-Батыр",
"771458", "Костанайская\ область",
"772759", "Алматинская\ область",
"771636", "Щучинский\ р\-н",
"771032", "Каражал",
"772635", "Жуалынский\ р\-н",
"740", "Калининградская\ обл\.",
"7475", "Тамбовская\ обл\.",
"771646", "Буландинский\ р\-н",
"771042", "Акой",
"7426", "Еврейская\ автономная\ обл\.",
"771445", "Алтынсаринский\ р\-н",
"771532", "Аккайынский\ р\-н",
"771842", "Майский\ р\-он",
"772530", "Темирлановка",
"772251", "Курчатов",
"772840", "Кербулакский\ р\-н",
"771435", "Житикаринский\ р\-н",
"771542", "Уалихановский\ р\-н",
"771832", "Иртышский\ р\-н",
"7834", "Республика\ Мордовия",
"772436", "Сырдарьинский\ р\-н",
"771230", "Атырауская\ область",
"772830", "Алакольский\ р\-н",
"772540", "Арыс",
"7813", "Ленинградская\ обл\.",
"7856", "Донецкая\ Народная\ Республика",
"772337", "Серебрянск",
"772153", "Абайский\ р\-н",
"771341", "Хобдинский\ р\-н",
"7485", "Ярославская\ обл\.",
"772779", "Райымбекский\ р\-н",
"7394", "Республика\ Тыва",
"7846", "Самарская\ обл\.",
"772347", "Жарминский\ р\-н",
"77142", "Костанай",
"771331", "Мартукский\ р\-н",
"772239", "Урджарский\ р\-н",
"7717", "Астана",
"771839", "Лебяжинский\ р\-н",
"7871", "Республика\ Чеченская",
"7384", "Кемеровская\ обл\.",
"7498", "Московская\ обл\.",
"771539", "Кызылжарский\ р\-н",
"772931", "Мангистауский\ р\-н",
"7423", "Приморский\ край",
"772156", "Шахтинск",
"77106", "Сатпаев",
"7495", "Московская\ обл\.",
"77185", "Шалдай",
"7860", "Херсонская\ область",
"7843", "Республика\ Татарстан",
"772433", "Аральский\ р\-н",
"772538", "имени\ Турара\ Рыскулова",
"771631", "Шортандинский\ р\-н",
"772154", "Бухар\-Жырауский\ р\-н",
"772637", "Байзакский\ р\-н",
"7816", "Новгородская\ обл\.",
"772772", "Капчагай",
"771641", "Астраханский\ р\-н",
"772838", "Коксуский\ р\-н",
"772548", "Шаян",
"771238", "Кзылкогинский\ р\-н",
"772149", "Осакаровский\ р\-н",
"772256", "Алгабас",
"771643", "Атбасарский\ р\-н",
"7865", "Ставропольский\ край",
"771334", "Мугалжарский\ р\-н",
"771437", "Камыстинский\ р\-н",
"772431", "Жалагашский\ р\-н",
"771633", "Ерейментауский\ р\-н",
"7872", "Республика\ Дагестан",
"771447", "Карабалыкский\ р\-н",
"77232", "Усть\-Каменогорск",
"771346", "Темирский\ р\-н",
"772345", "Жарминский\ р\-н",
"771138", "Казталовский\ р\-н",
"77187", "Экибастуз",
"77272983", "Каскелен",
"771336", "Хромтауский\ р\-н",
"772752", "Илийский\ р\-н",
"772335", "Зыряновск",
"771039", "Приозерск",
"7385", "Алтайский\ край",
"771449", "Тарановский\ р\-н",
"771141", "Жангалинский\ р\-н",
"772353", "Бородулихинский\ р\-н",
"772137", "Сарань",
"7811", "Псковская\ обл\.",
"7869", "г\.\ Севастополь",
"7388", "Республика\ Алтай",
"771131", "Зеленовский\ р\-н",
"771439", "Джангильдинский\ р\-н",
"7494", "Костромская\ обл\.",
"772147", "Каркаралинский\ р\-н",
"7820", "Вологодская\ обл\.",
"771037", "Актогайский\ р\-н",
"772438", "Казалинский\ р\-н",
"772843", "Лепсы",
"772533", "Туркестан",
"772775", "Енбекшиказахский\ р\-н",
"772543", "Аксумбе",
"772833", "Алакольский\ р\-н",
"771233", "Курмангазинский\ р\-н",
"771648", "Жаркаинский\ р\-н",
"772541", "Мырзакент",
"772831", "Панфиловский\ р\-н",
"771231", "Исатайский\ р\-н",
"771537", "Тимирязевский\ р\-н",
"771456", "Качар",
"772841", "Аксуский\ р\-н",
"772531", "Аксукент",
"771638", "Аккольский\ р\-н",
"772237", "Аязог",
"7499", "г\.\ Москва",
"771837", "Аксуский\ р\-н",
"771547", "Жамбылский\ р\-н",
"7812", "г\.\ Санкт\-Петербург",
"771330", "Хромтауский\ р\-н",
"772938", "Тупкараганский\ р\-н",
"772332", "Шемонаихинский\ р\-н",
"771454", "Наурзумский\ р\-н",
"772639", "Сарысуский\ р\-н",
"771133", "Бурлинский\ р\-н",
"771340", "Хобдинский\ р\-н",
"772351", "Бородулихинский\ р\-н",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"77279", "Алматы",
"772342", "Катон\-Карагайский\ р\-н",
"771143", "Теректинский\ р\-н",
"771146", "Акжаикский\ р\-н",
"771348", "Шалкарский\ р\-н",
"7390", "Республика\ Хакасия",
"7842", "Ульяновская\ обл\.",
"77102", "Жезказган",
"771136", "Акжаикский\ р\-н",
"771453", "Аулиекольский\ р\-н",
"771134", "Сырымский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"7347", "Республика\ Башкортостан",
"772642", "Мойынкумский\ р\-н",
"77212", "Караганда",
"772777", "Райымбекский\ р\-н",
"7474", "Липецкая\ обл\.",
"771144", "Казталовский\ р\-н",
"771630", "Боровое",
"771035", "Улытауский\ р\-н",
"7415", "Камчатский\ край",
"772632", "Меркенский\ р\-н",
"772339", "Курчумский\ р\-н",
"771545", "Жамбылский\ р\-н",
"7841", "Пензенская\ обл\.",
"771236", "Махамбетский\ р\-н",
"772836", "Ескельдинский\ р\-н",
"772546", "Шолаккорган",
"7349", "Ямало\-Ненецкий\ АО",
"771442", "Федоровский\ р\-н",
"771535", "Габита\ Мусрепова\ р\-н",
"771845", "Павлодар",
"7487", "Тульская\ обл\.",
"771451", "Сарыкольский\ р\-н",
"772536", "Кентау",
"7851", "Астраханская\ обл\.",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"77182", "Павлодар",
"77222", "Семипалатинск",
"772534", "Жетысай",
"7712303", "Тензиз",
"7873", "Республика\ Ингушетия",
"7484", "Калужская\ обл\.",
"77152", "Петропавловск",
"7395", "Иркутская\ обл\.",
"772834", "Каратальский\ р\-н",
"772544", "Шаульдер",
"771234", "Индерский\ р\-н",
"7421", "Хабаровский\ край",
"772757", "Акший",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '336' => [
                          'Asia/Yekaterinburg'
                        ],
               '33622' => [
                            'Asia/Almaty'
                          ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '856' => [
                          'Europe/Moscow'
                        ],
               '857' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;