package OpenInteract::Handler::Redirect;

# $Id: Redirect.pm,v 1.7 2003/08/13 03:15:51 lachoy Exp $

use strict;

$OpenInteract::Redirect::VERSION = sprintf("%d.%02d", q$Revision: 1.7 $ =~ /(\d+)\.(\d+)/);

my $MSG = '<p>Going back from whence we came, which is hopefully <a href="%%URL%%">%%URL%%</a></p>';

my $BASE_PAGE = <<'EOF';
<html>
 <head>
  <meta http-equiv="refresh" content="0; URL=%%URL%%">
 </head>
 <body>
  %%MSG%%
 </body>
</html>
EOF

sub handler {
    my ( $class, $p ) = @_;
    $p->{url} ||= '/';

    my $R = OpenInteract::Request->instance;
    $R->{page}{_no_template_}++;

    my $display_info = $R->CONFIG->{display_info};
    if ( $display_info->{use_http_redirect} ) {
        $R->{page}{http_redirect} = $p->{url};
        return undef;
    }
    elsif ( $display_info->{use_meta_redirect} ) {

        # the url in the meta refresh tag doesn't like semicolons
        $p->{url} =~ s/;/&/g;

        $R->DEBUG && $R->scrib( 1, "Trying to redirect to [$p->{url}]" );
        my $msg  = $MSG;
        $msg  =~ s|%%URL%%|$p->{url}|g;
        unless ( $R->CONFIG->{display_info}{show_redirect_message} ) {
            $msg = '<!-- ' . $msg . '-->';
        }
        my $page = $BASE_PAGE;
        $page =~ s|%%MSG%%|$msg|;
        $page =~ s|%%URL%%|$p->{url}|g;
        return $page;
    }
    else {
        return <<ERROR;
<h1>Error</h1>

<p>Server misconfiguration: neither 'use_meta_redirect' nor
'use_http_redirect' are set, so we cannot do an automatic redirect.
You'll have to go to <a href="$p->{url}">the new location</a>
manually.</p>
ERROR
    }
}

1;

__END__

=head1 NAME

OpenInteract::Handler::Redirect - Process redirect requests

=head1 SYNOPSIS

 # In server configuration, specify that you want to use meta
 # redirects
 
 [display_info]
 use_meta_redirect = 1
 
 # Or that you want to use HTTP redirects
 use_http_redirect = 1
 
 # Actually call the redirect
 
 my ( $redir_class, $redir_method ) = $R->lookup_action( 'redirect' );
 $redir_class->$redir_method( { url => '/where/I/want/to/go' } );

=head1 DESCRIPTION

This handler processes redirect requests. Just pass in:

 { url => '/url/to/go/to' }

As the first parameter and OI will send you there.

=head1 METHODS

B<handler( \%params )>

Process the request for redirection.

=head1 COPYRIGHT

Copyright (c) 2001-2002 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

Teemu Arina <teemu@ionstream.fi> (for HTTP edirection code here and in
L<OpenInteract|OpenInteract>)
